/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.ntutil.security.base;

import filenet.vw.ntutil.PEBytePointer;
import filenet.vw.ntutil.VWNTUTIL_DLL;
import filenet.vw.ntutil.security.base.AuthException;
import filenet.vw.ntutil.security.base.IVWNTSSPIServer;
import filenet.vw.ntutil.security.base.NativeSSPIPackage;
import filenet.vw.ntutil.security.base.SSPISecHandle;
import filenet.vw.ntutil.trace;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class SSPIServer
extends UnicastRemoteObject
implements IVWNTSSPIServer {
    private SSPISecHandle m_credHandle = new SSPISecHandle();
    private SSPISecHandle m_secContext = new SSPISecHandle();
    private PEBytePointer m_outPtr = null;
    private PEBytePointer m_inPtr = null;
    private boolean m_contextEstablished = false;
    private boolean m_handleEstablished = false;
    private boolean m_done = false;
    private boolean m_firstTime = true;
    private boolean m_terminated = false;

    private native boolean genServerContext(boolean var1) throws AuthException;

    private native void terminateSession();

    public static native void initIDs();

    public SSPIServer() throws RemoteException, Exception {
        try {
            this.m_outPtr = new PEBytePointer(NativeSSPIPackage.getPackageBufSize());
            this.m_inPtr = new PEBytePointer(NativeSSPIPackage.getPackageBufSize());
            this.m_outPtr.setUsedSize(0);
            this.m_inPtr.setUsedSize(0);
        }
        catch (Throwable t) {
            throw new Exception(t.getMessage());
        }
    }

    public byte[] accept(byte[] clientData) throws RemoteException, Exception {
        if (this.m_terminated) {
            throw new Exception("SSPIServer: Server Session terminated!");
        }
        try {
            trace.println("SSPIServer.accept");
            this.m_inPtr.setBytes(clientData);
            if (this.genServerContext(this.m_firstTime)) {
                byte[] sentData = this.m_outPtr.getBytes();
                this.m_firstTime = false;
                trace.println("SSPIServer.accept -- got to send on more..");
                return sentData;
            }
        }
        catch (Throwable e) {
            throw new Exception(e.getMessage());
        }
        throw new Exception("SSPIServer: The authentication failed!.");
    }

    public SSPISecHandle getContext() throws RemoteException, Exception {
        if (this.m_contextEstablished && this.m_done && !this.m_terminated) {
            trace.println("SSPIServer.getContext... " + this.m_secContext.toString());
            return this.m_secContext;
        }
        throw new Exception("SSPIServer: Unable to obtain context.");
    }

    public void terminate() throws RemoteException, Exception {
        try {
            if (!this.m_terminated) {
                this.m_terminated = true;
                this.terminateSession();
                this.m_outPtr.free();
                this.m_inPtr.free();
            }
        }
        catch (Throwable t) {
            throw new Exception(t.getMessage());
        }
    }

    static {
        if (VWNTUTIL_DLL.initLibrary()) {
            SSPIServer.initIDs();
        }
    }
}

